#pragma once

#include "SFML/Graphics.hpp"

struct TransformProperties
{

public:

	void SetPosition(const sf::Vector2f& position);
	void SetRotation(float rotation);
	void SetScale(const sf::Vector2f& scale);

	const sf::Vector2f& GetPosition() const { return m_position; }
	const float GetRotation() const { return m_rotation; }
	const sf::Vector2f& GetScale() const { return m_scale; }

	sf::Transform& GetTransform();

private:

	sf::Vector2f m_position;
	sf::Vector2f m_scale = sf::Vector2f(1.f, 1.f);
	float m_rotation = 0.f;

	bool m_isDirty = false;
	sf::Transform m_cachedTransform;
};