#pragma once

#include "SFMLEngine/Core/Interfaces/EngineTickListener.h"
#include "SFMLEngine/Core/InputManager.h"
#include "SFMLEngine/EntitySystem/EntityId.h"
#include "SFMLEngine/Serialization/IArchive.h"

class Game 
	: public IEngineTickListener
{

public:

	static Game* Instance();
	
	Game();
	~Game();

private:

	Game(const Game&) = delete;
	Game& operator=(Game const&) = delete;

	virtual void OnStart() override;
	virtual void OnTick(float deltaSeconds) override;

	void LeftClick();

	void SaveState();
	void LoadState();

	void Serialize(IArchive& archive);

	InputBindingScope m_inputScope;

	static Game* s_pInstance;
};