#include "Game.h"

#include "SFMLEngine/Core/Engine.h"

#include "SFMLEngine/EntitySystem/EntitySystem.h"
#include "SFMLEngine/ComponentSystem/ComponentSystem.h"

#include "SFMLEngine/GameFramework/Rendering/SpriteRenderSystem.h"
#include "SFMLEngine/GameFramework/Rendering/TextRenderSystem.h"
#include "SFMLEngine/GameFramework/TransformProperties.h"
#include "SFMLEngine/GameFramework/AudioProperties.h"

#include "SFMLEngine/Serialization/BinArchive.h"

#include <SFML/Graphics.hpp>

Game* Game::s_pInstance = nullptr;

Game* Game::Instance()
{
	return s_pInstance;
}

Game::Game()
{
	s_pInstance = this;
}

Game::~Game()
{
	if (s_pInstance == this)
	{
		s_pInstance = nullptr;
	}
}

void Game::OnStart()
{
	sf::RenderWindow& window = Engine::Instance()->GetMainWindow();
	EntitySystem& entitySystem = EntitySystem::Instance();

	//Spawn your entities here

	InputManager& inputManager = Engine::Instance()->GetInputManager();
	inputManager.RegisterKeyboardBinding(sf::Keyboard::S, EInputEventType::Pressed, std::bind(&Game::SaveState, this), m_inputScope);
	inputManager.RegisterKeyboardBinding(sf::Keyboard::L, EInputEventType::Pressed, std::bind(&Game::LoadState, this), m_inputScope);
	inputManager.RegisterMouseBinding(sf::Mouse::Left, EInputEventType::Pressed, std::bind(&Game::LeftClick, this), m_inputScope);
}

void Game::OnTick(float deltaSeconds)
{
	EntitySystem& entitySystem = EntitySystem::Instance();

}

void Game::LeftClick() 
{
}

void Game::SaveState()
{
	BinaryOutputArchive outputArchive("../Assets/game.dat");
	Serialize(outputArchive);
}

void Game::LoadState()
{
	BinaryInputArchive inputArchive("../Assets/game.dat");
	Serialize(inputArchive);
}

void Game::Serialize(IArchive& archive)
{
	//Save/Load your game state here
}
