#pragma once

#include <vector>

class GameState
{
public:
	virtual ~GameState() = default;
	
	virtual void OnEnter(GameState* pPrevState) {};
	virtual void Update(float deltaSeconds) {}
	virtual void OnExit(GameState* pNextState);

protected:

	std::vector<int> m_ownedEntityIds;
};

class TitleScreenGameState : public GameState
{
	virtual void OnEnter(GameState* pPrevState) override;
	virtual void Update(float deltaSeconds) override;
	virtual void OnExit(GameState* pNextState) override;

private:

	class TextRenderComponent* m_pPromptComponent = nullptr;
	int m_inputCallbackId = 0;
};

class IngameGameState : public GameState
{
	virtual void OnEnter(GameState* pPrevState) override;
	virtual void Update(float deltaSeconds) override;

public:

	int m_tankOneId = 0;
	int m_tankTwoId = 0;
	std::vector<int> m_boundIds;

private:

	float m_secondsUntilBuffSpawn = 0.f;
	float m_secondsBetweenBuffSpawn = 4.f;

	void CreatePlayfieldBounds();
	void SpawnRandomBuff();

};

class GameOverGameState : public GameState
{
protected:

	virtual void OnEnter(GameState* pPrevState) override;
	virtual void OnExit(GameState* pNextState) override;

public:

	int loserEntityId = 0;

private:

	int m_inputCallbackId = 0;

};