#pragma once

#include "Engine/EntitySystem/EntitySystemDefinitions.h"
#include "Engine/Input/InputManager.h"

class SpriteComponent;
class RigidbodyComponent;

class PikachuEntity : public Entity
{
public:

	virtual void Init() override;
	virtual void Shutdown() override;
	virtual void Update(float deltaSeconds) override;

protected:

	void OnInputPressed();

	SpriteComponent* m_mySpriteComponent = nullptr;
	int m_inputCallbackId = 0;

	std::vector<std::weak_ptr<Entity>> m_bullets;
};