#include "PikachuEntity.h"

#include "Engine/EntitySystem/EntityFactory.h"
#include "Engine/EntitySystem/Components/SpriteComponent.h"
#include "Engine/EntitySystem/Components/RigidbodyComponent.h"
#include "Engine/Engine.h"

void PikachuEntity::Init()
{
	m_mySpriteComponent = AddComponent<SpriteComponent>();
	m_mySpriteComponent->SetSpriteByPath("../Assets/pikachu.png", true);

	m_inputCallbackId = Engine::GetInstance()->GetInputManager().Register(sf::Mouse::Left, EInputEvent::Pressed, std::bind(&PikachuEntity::OnInputPressed, this));
}

void PikachuEntity::Shutdown()
{
	Engine::GetInstance()->GetInputManager().Unregister(m_inputCallbackId);
}

void PikachuEntity::Update(float deltaSeconds)
{
	InputManager& manager = Engine::GetInstance()->GetInputManager();

	float movementSpeed = 200.f;
	sf::Vector2f movementVector;

	// vertical
	if (manager.IsKeyPressed(sf::Keyboard::W))
	{
		movementVector.y -= 1.f;
	}
	
	if (manager.IsKeyPressed(sf::Keyboard::S))
	{
		movementVector.y += 1.f;
	}

	// horizontal
	if (manager.IsKeyPressed(sf::Keyboard::A))
	{
		movementVector.x -= 1.f;
	}
	
	if (manager.IsKeyPressed(sf::Keyboard::D))
	{
		movementVector.x += 1.f;
	}

	SetPosition(GetPosition() + (movementVector * deltaSeconds * movementSpeed));
}

void PikachuEntity::OnInputPressed()
{
	Destroy();
}