#pragma once

enum class EBuffStat
{
	MoveSpeed,
	TurnSpeed,
	BulletCount,
	Armor
};

class Buff
{
public:

	virtual ~Buff() = default;
	virtual void EvaluateStat(EBuffStat stat, float& value) {}

	float lifetime = -1.f;

};

class ArmorBuff : public Buff
{
public:

	ArmorBuff() = default;
	ArmorBuff(float multiplier);

	virtual void EvaluateStat(EBuffStat stat, float& value) override;

	float incomingDamageMultipier = 0.5f;
};

class MovementSpeedBuff : public Buff
{
public:
	virtual void EvaluateStat(EBuffStat stat, float& value) override;

	float flatMoveSpeedIncrease = 0.f;
	float multiplierMoveSpeedIncrease = 1.f;
};

class TurnSpeedBuff : public Buff
{
public:
	virtual void EvaluateStat(EBuffStat stat, float& value) override;

	float flatTurnSpeedIncrease = 0.f;
	float multiplierTurnSpeedIncrease = 1.f;
};

class LifetimeTurnSpeedBuff : public Buff
{
public:
	virtual void EvaluateStat(EBuffStat stat, float& value) override;
};

class BulletCountBuff : public Buff
{
public:
	virtual void EvaluateStat(EBuffStat stat, float& value) override;

	int additionalBulletsPerFire = 0;
};