#include "BuffDefinitions.h"

void MovementSpeedBuff::EvaluateStat(EBuffStat stat, float& value)
{
	if (stat == EBuffStat::MoveSpeed)
	{
		value += flatMoveSpeedIncrease;
		value *= multiplierMoveSpeedIncrease;
	}
}

void TurnSpeedBuff::EvaluateStat(EBuffStat stat, float& value)
{
	if (stat == EBuffStat::TurnSpeed)
	{
		value += flatTurnSpeedIncrease;
		value *= multiplierTurnSpeedIncrease;
	}
}

void BulletCountBuff::EvaluateStat(EBuffStat stat, float& value)
{
	if (stat == EBuffStat::BulletCount)
	{
		value += additionalBulletsPerFire;
	}
}

void LifetimeTurnSpeedBuff::EvaluateStat(EBuffStat stat, float& value)
{
	if (stat == EBuffStat::TurnSpeed)
	{
		value *= (1.f + (lifetime * 0.5f));
	}
}

ArmorBuff::ArmorBuff(float multiplier)
	: incomingDamageMultipier(multiplier)
{}

void ArmorBuff::EvaluateStat(EBuffStat stat, float& value)
{
	if (stat == EBuffStat::Armor)
	{
		value *= incomingDamageMultipier;
	}
}
